#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(31120);
  script_version("$Revision: 1.1 $");

  script_bugtraq_id(27893);

  script_name(english:"Plumtree name Parameter Cross-Site Scripting Vulnerabilities");
  script_summary(english:"Tries to inject script code into ");

  desc = "
Synopsis :

The remote web server contains an application affected by a cross-site
scripting vulnerability. 

Description :

The version of the Plumtree portal included with BEA AquaLogic
Interaction / Plumtree Foundation and installed on the remote host
fails to sanitize user-supplied input to the 'name' parameter of the
'portal/server.pt' script before using it to generate dynamic HTML
output.  An unauthenticated attacker can exploit this to inject
arbitrary HTML and script code into a user's browser to be executed
within the security context of the affected site. 

See also :

http://www.procheckup.com/Vulnerability_PR06-12.php
http://www.securityfocus.com/archive/1/488346
http://dev2dev.bea.com/pub/advisory/259

Solution :

Apply the appropriate patch as suggested in the vendor advisory above. 

Risk factor :

Medium / CVSS Base Score : 4.3
(CVSS2#AV:N/AC:M/Au:N/C:N/I:P/A:N)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses : XSS");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);


exploit = string('";}</script>', "<script>alert('", SCRIPT_NAME, "')</script>");


# Loop through directories.
if (thorough_tests) dirs = make_list("/portal", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Inject some script code.
  req = http_get(
    item:string(
      dir, "/server.pt?",
      "open=space&",
      "name=", urlencode(str:exploit)
    ),
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if we see our exploit in the results.
  if (
    "function OpenerAS_GetParentSpaceName()" >< res &&
    string('return "', exploit, '";') >< res
  )
  {
    security_warning(port);
    exit(0);
  }
}
