#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web portal is protected with default credentials. 

Description :

The remote host is running Plumtree portal, a corporate web portal. 

The remote installation of the Plumtree portal is configured to use
default credentials to control administrative access.  Knowing these,
an attacker can gain control of the affected application. 

Solution :

Assign a password to the 'Administrator' account. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(28373);
  script_version("$Revision: 1.1 $");

  script_name(english:"Plumtree Portal Default Credentials");
  script_summary(english:"Tries to login to the portal with default credentials");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);


user = "Administrator";
pass = "";


# Loop through directories.
dirs = make_list("/portal", cgi_dirs());

foreach dir (dirs)
{
  # Check whether the login script exists.
  url = string(dir, "/server.pt?");
  req = http_get(item:url, port:port);
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # If it does...
  if ('PTIncluder.' >< res && "!--Portal Version: " >< res)
  {
    # Try to log in.
    postdata = string(
      "in_hi_space=Login&",
      "in_hi_spaceID=2&",
      "in_hi_control=Login&",
      "in_hi_dologin=true&",
      "in_tx_username=", user, "&",
      "in_pw_userpass=", pass, "&",
      "in_se_authsource="
    );
    req = string(
      "POST ", url, " HTTP/1.1\r\n",
      "Host: ", get_host_name(), "\r\n",
      "User-Agent: ", get_kb_item("global_settings/http_user_agent"), "\r\n",
      "Content-Type: application/x-www-form-urlencoded\r\n",
      "Content-Length: ", strlen(postdata), "\r\n",
      "\r\n",
      postdata
    );
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
    if (res == NULL) exit(0);

    # There's a problem if...
    if (
      # we got in...
      "Set-Cookie: plloginoccured=true;" ><res &&
      # as Administrator
      "in_hi_userid=1" >< res
    )
    {
      report = string(
        desc,
        "\n\n",
        "Plugin output :\n",
        "\n",
        "Nessus was able to gain access using the following credentials :\n",
        "\n",
        "  User     : ", user, "\n",
        "  Password : ", pass, "\n"
      );
      security_hole(port:port, data:report);
    }
  }
}
