#TRUSTED 4dfb5b24189f16f89aefaf5e3cec9836ba5fe8e1fca2b3eb4b6292649dfa28d7d4bd9c074bca5dc217fa6fad7a8af1003814274ed98a7a9d75f74ed49bcf266bbe8bf9a8995641a466d24d25a402ca186a3aaec91976ce53d8ccf64c6d1c4eeb24e611aa6e8b9d4ef01a2fe2ef7505068b7568fd3cd6522b43269c23efbee813cfdcc13e0bec850597ab8ae3bd33115966b144cc92c70c7385d9d01f2b3802c8601c278e19814261d1b287fffae6a1d9a391ed84bb2472e7ef8deab5fafc70cf694f6d39f4d7c8f664919b57aae81a94a8e4f8eca61363a28ddf6e4a6374847d5020e1becca50780cb630be0f1720cea466079d9411ebc07cfcd4ea60bb8c37f3d0f3d03e7a6e3055e9542b4f6199b62eafcd740cd56ccaf81866334ddf6268c684ee7ac96ad015b1ed43f88c3ce7e1ec2a118b9eea703edc5625b3d41620068eec8e0de456b21da110ef19993e2c456febac2797496d1fca9443b8886b50f3cf86b235e0bc0f3571aefbbe27b6684c80e880f02ef479c26456f72e2a0c3177b0a824fd571a432f0ca16052296624680634c45471e25470e82ece9a0622924486cd075aace214f7151a1db1919d657c080f0564689bb459be0d8bd436dcc27e75678c6e80ed1c8759310cab61f5d9df7626ebb2bb0b48312d7751877abd812411aef8796b2ab3e04300245bb9f4b9f2827efd67f57d2b591b0f245b88874a9bd
#
# This script was written by Michel Arboi <mikhail@nessus.org>
#
# GPLv2
#
#
# Modifications by Tenable Network Security, Inc:
#
# - Report 
# - Properly parse the result
# - Make sure that the selected LANG is C
#
#


 desc = "
Synopsis :

Using netstat, it is possible to identify what daemon or service is running 
on each remote port.

Description :

By using the Linux-specific 'netstat -anp' command and by logging into the
remote host, , it is possible to obtain the names of the processes listening 
on the remote ports.

Solution :

None

Risk factor :

None";

if(description)
{
 script_id(25221);
 script_version ("1.1");
 script_name(english: "Remote listeners enumeration");
 

 script_description(english:desc);
 
 script_summary(english: "Find which process is listening on each port with netstat");
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Michel Arboi");
 script_family(english: "Service detection");

 script_dependencies("ssh_settings.nasl");
 script_require_ports("Services/ssh", 22);
 script_require_keys("Host/uname");
 exit(0);
}


include("ssh_func.inc");

ip = get_host_ip();
buf = "";

found = 0;

ostype = '';
uname = get_kb_item("Host/uname");
if (! uname) exit(0);



if ( 'Linux' >< uname )
{
 cmd = 'LANG=C netstat -anp';
 if ( islocalhost() )
 {
  if ( ! defined_func("pread") ) exit(0);
  buf = pread(cmd:"bash", argv:make_list("bash", "-c", cmd));
 }
 else
 {
  soc = ssh_login_or_reuse_connection();
  if ( ! soc ) exit(0);
  buf = ssh_cmd(socket:soc, cmd:cmd);
  ssh_close_connection();
 }

 if (! buf ) exit(0);

 foreach line (split(buf, keep: 0))
  {
   v = eregmatch(string: line, pattern: "^(tcp|udp) *[0-9]+ *[0-9]+ *([0-9.]+):([0-9]+) *([0-9.]+):[0-9*]+ *LISTEN *[0-9]+/([^:]*)(:.*|$)");
   if (isnull(v)) continue;
   if (v[2] == '0.0.0.0' || v[2] == ip)
   {
    p = int(v[3]); 
    if ( p < 0 || p > 65535 ) continue;
    proto = tolower(v[1]); 
    if ( proto != "tcp" && proto != "udp" ) continue;
    exe = v[5];
    if ( isnull(exe) ) continue;

   security_note(port: p, proto: proto, data:
 'The Linux process \''+exe+ '\' is listening on this port');
    set_kb_item(name: 'Host/Listeners/'+proto+'/'+p, value: exe);
    found ++;
   }
  }

if ( found ) set_kb_item(name:"Host/Listeners/Check", value:cmd - "LANG=C ");
}
