#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10195);
 script_version ("$Revision: 1.28 $");

 name["english"] = "Open Web Proxy Server";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote web proxy server accepts requests. 

Description :

The remote web proxy accepts unauthenticated HTTP requests from the
Nessus scanner.  By routing requests through the affected proxy, a
user may be able to gain some degree of anonymity while browsing web
sites, which will see requests as originating from the remote host
itself rather than the user's host. 

Solution:

Make sure access to the proxy is limited to valid users / hosts.
 
Risk factor : 

None";
 script_description(english:desc["english"]);
 
 summary["english"] = "Determines if we can use the remote web proxy"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2003-2007 Tenable Network Security, Inc.");
 
 family["english"] = "Firewalls"; 
 script_family(english:family["english"]);
 script_dependencie("find_service1.nasl");
 script_require_ports("Services/http_proxy", 3128, 8080);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");
include("http_keepalive.inc");
include("misc_func.inc");

ports = add_port_in_list(list:get_kb_list("Services/http_proxy"), port:3128);
ports = add_port_in_list(list:ports, port:8080);
ports = add_port_in_list(list:ports, port:80);


foreach port (ports)
{
  req = 'GET http://www.nessus.org/check_proxy.html HTTP/1.0\r\n\r\n';
  soc = open_sock_tcp(port);
  if ( soc ) 
  {
    send(socket:soc, data:req);
    buffer = http_recv(socket:soc);
    close(soc);
    if ( "@NESSUS:OK@" >< buffer )
    {
      security_note(port);
      set_kb_item(name:"Proxy/usage", value:TRUE);
      set_kb_item(name:"Services/http_proxy", value:port);
    }
  }
}
