#
# (C) Tenable Network Security
#


if (description) {
  script_id(20395);
  script_version("$Revision: 1.11 $");

  script_cve_id(
    "CVE-2005-2340",
    "CVE-2005-3707",
    "CVE-2005-3708",
    "CVE-2005-3709",
    "CVE-2005-3710",
    "CVE-2005-3711",
    "CVE-2005-3713",
    "CVE-2005-4092"
  );
  script_bugtraq_id(16202);
  script_xref(name:"OSVDB", value:"22333");
  script_xref(name:"OSVDB", value:"22334");
  script_xref(name:"OSVDB", value:"22335");
  script_xref(name:"OSVDB", value:"22336");
  script_xref(name:"OSVDB", value:"22337");
  script_xref(name:"OSVDB", value:"22338");

  script_name(english:"QuickTime < 7.0.4 (Windows)");
  script_summary(english:"Checks for QuickTime < 7.0.4 on Windows");
 
  desc = "
Synopsis :

The remote version of QuickTime is affected by multiple code execution
vulnerabilities. 

Description :

The remote Windows host is running a version of QuickTime prior to
7.0.4. 

The remote version of QuickTime is vulnerable to various buffer
overflows involving specially-crafted image and media files.  An
attacker may be able to leverage these issues to execute arbitrary
code on the remote host by sending a malformed file to a victim and
have him open it using QuickTime player. 

See also : 

http://lists.grok.org.uk/pipermail/full-disclosure/2006-January/041289.html
http://lists.grok.org.uk/pipermail/full-disclosure/2006-January/041290.html
http://lists.grok.org.uk/pipermail/full-disclosure/2006-January/041291.html
http://lists.grok.org.uk/pipermail/full-disclosure/2006-January/041292.html
http://lists.grok.org.uk/pipermail/full-disclosure/2006-January/041333.html
http://lists.grok.org.uk/pipermail/full-disclosure/2006-January/041334.html
http://lists.grok.org.uk/pipermail/full-disclosure/2006-January/041335.html
http://www.cirt.dk/advisories/cirt-41-advisory.pdf
http://lists.apple.com/archives/security-announce/2006/Jan/msg00001.html
http://docs.info.apple.com/article.html?artnum=303101

Solution :

Upgrade to QuickTime version 7.0.4 or later.

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
 
  script_copyright(english:"This script is Copyright (C) 2006-2007 Tenable Network Security");

  script_dependencies("quicktime_installed.nasl");
  script_require_keys("SMB/QuickTime/Version");

  exit(0);
}


ver = get_kb_item("SMB/QuickTime/Version");
if (ver && ver =~ "^([0-6]\.|7\.0\.[0-3]$)") security_hole(get_kb_item("SMB/transport"));
