#
# (C) Tenable Network Security
#


if (description)
{
  script_id(24761);
  script_version("$Revision: 1.7 $");

  script_cve_id(
    "CVE-2007-0711",
    "CVE-2007-0712",
    "CVE-2007-0713",
    "CVE-2007-0714",
    "CVE-2007-0715",
    "CVE-2007-0716",
    "CVE-2007-0717",
    "CVE-2007-0718"
  );
  script_bugtraq_id(22827, 22839, 22843, 22844);
  script_xref(name:"OSVDB", value:"33898");
  script_xref(name:"OSVDB", value:"33899");
  script_xref(name:"OSVDB", value:"33900");
  script_xref(name:"OSVDB", value:"33901");
  script_xref(name:"OSVDB", value:"33902");
  script_xref(name:"OSVDB", value:"33903");
  script_xref(name:"OSVDB", value:"33904");
  script_xref(name:"OSVDB", value:"33905");

  script_name(english:"QuickTime < 7.1.5 (Windows)");
  script_summary(english:"Checks version of QuickTime on Windows");
 
  desc = "
Synopsis :

The remote Windows host contains an application that is prone to
multiple attacks. 

Description :

According to its version, the installation of QuickTime on the remote
Windows host is affected by multiple buffer overflows.  An attacker
may be able to leverage these issues to crash the affected application
or to execute arbitrary code on the remote host by sending a
specially-crafted file to a victim and having him open it using
QuickTime. 

See also : 

http://docs.info.apple.com/article.html?artnum=305149

Solution :

Upgrade to QuickTime version 7.1.5 or later. 

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
 
  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("quicktime_installed.nasl");
  script_require_keys("SMB/QuickTime/Version");

  exit(0);
}


ver = get_kb_item("SMB/QuickTime/Version");
if (
  ver && 
  ver =~ "^([0-6]\.|7\.(0\.|1\.[0-4]([^0-9]|$)))"
) security_hole(get_kb_item("SMB/transport"));
