#
# (C) Tenable Network Security
#


if (description)
{
  script_id(25123);
  script_version("$Revision: 1.6 $");

  script_cve_id("CVE-2007-2175");
  script_bugtraq_id(23608);
  script_xref(name:"OSVDB", value:"34178");

  script_name(english:"QuickTime < 7.1.6 (Windows)");
  script_summary(english:"Checks version of QuickTime on Windows");
 
  desc = "
Synopsis :

The remote Windows host contains an application that is prone to
multiple attacks. 

Description :

According to its version, the installation of QuickTime on the remote
Windows host contains a bug that might allow a rogue Java program to
write anywhere in the heap. 

An attacker may be able to leverage this issue to execute arbitrary
code on the remote host by luring a victim into visiting a rogue page
containing a malicious Java applet. 

See also : 

http://docs.info.apple.com/article.html?artnum=305446

Solution :

Upgrade to QuickTime version 7.1.6 or later. 

Risk factor :

High / CVSS Base Score : 7.6
(CVSS2#AV:N/AC:H/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
 
  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");

  script_dependencies("quicktime_installed.nasl");
  script_require_keys("SMB/QuickTime/Version");

  exit(0);
}


ver = get_kb_item("SMB/QuickTime/Version");
if (
  ver && 
  ver =~ "^([0-6]\.|7\.(0\.|1\.[0-5]([^0-9]|$)))"
) security_hole(get_kb_item("SMB/transport"));
