#
# (C) Tenable Network Security
#


  desc = "
Synopsis :

The remote version of QuickTime is affected by a buffer overflow
vulnerability. 

Description :

A buffer overflow vulnerability exists in the RTSP URL handler in the
version of QuickTime installed on the remote host.  Using either HTML,
Javascript or a QTL file as attack vector and an RTSP URL with a long
path component, a remote attacker may be able to leverage this issue
to execute arbitary code on the remote host subject to the user's
privileges. 

See also :


http://applefun.blogspot.com/2007/01/moab-01-01-2007-apple-quicktime-rtsp.html
http://projects.info-pull.com/moab/MOAB-01-01-2007.html
http://docs.info.apple.com/article.html?artnum=304989
http://lists.apple.com/archives/Security-announce/2007/Jan/msg00000.html
http://www.kb.cert.org/vuls/id/442497http://secunia.com/blog/7/

Solution :

Apply Apple's Security Update 2007-001, which is available via the
'Apple Software Update' application, installed with the most recent
version of QuickTime or iTunes. 

Risk factor :

Medium / CVSS Base Score : 6.8
(CVSS2#AV:N/AC:M/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(24268);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-0015");
  script_bugtraq_id(21829);
  script_xref(name:"OSVDB", value:"31023");

  script_name(english:"QuickTime RTSP URL Handler Buffer Overflow Vulnerability (Windows)");
  script_summary(english:"Checks version of QuickTime on Windows");
 
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
 
  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");

  script_dependencies("quicktime_installed.nasl");
  script_require_keys("SMB/QuickTime/Version");

  exit(0);
}


ver_str = get_kb_item("SMB/QuickTime/Version");
path = get_kb_item("SMB/QuickTime/Path");
if (isnull(path)) path = "n/a";

if (ver_str)
{
  ver = split(ver_str, sep:'.', keep:FALSE);
  for (i=0; i<4; i++)
    ver[i] = int(ver[i]);

  fix = split("7.1.3.191", sep:'.', keep:FALSE);
  for (i=0; i<4; i++)
    fix[i] = int(fix[i]);

  for (i=0; i<max_index(ver); i++)
    if ((ver[i] < fix[i]))
    {
      version = string(ver[0], ".", ver[1], ".", ver[2], ".", ver[3]);
      report = desc + string(
        "\n\n",
        "Plugin output :\n",
        "\n",
        "Version ", ver_str, " of QuickTime is installed in : \n",
        "\n",
        "  ", path, "\n"
      );
      security_warning(port:get_kb_item("SMB/transport"), data:report);
      break;
    }
    else if (ver[i] > fix[i])
      break;
}
