#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(27591);
  script_version("$Revision: 1.2 $");

  script_cve_id(
    "CVE-2007-2263",
    "CVE-2007-2264",
    "CVE-2007-3410",
    "CVE-2007-4599",
    "CVE-2007-5080", 
    "CVE-2007-5081"
  );
  script_bugtraq_id(24658, 26214, 26284);

  script_name(english:"RealPlayer for Windows < 6.0.12.1662");
  script_summary(english:"Checks version of RealPlayer for Windows");
 
  desc = "
Synopsis :

The remote Windows application is affected by several buffer overflow
vulnerabilities. 

Description :

According to its version number, the installed version of RealPlayer /
RealOne Player / RealPlayer Enterprise on the remote Windows host
suffers from several buffer overflows involving specially-crafted
media files (eg, '.mp3', '.rm', '.SMIL', '.swf', '.ram', and '.pls'). 
If an attacker can trick a user on the affected system into opening
such a file or browsing to a specially-crafted web page, he may be
able to exploit one of these issues to execute arbitrary code subject
to the user's privileges on the affected host. 

See also :

http://www.securityfocus.com/archive/1/482855/30/0/threaded
http://www.securityfocus.com/archive/1/482856/30/0/threaded
http://www.securityfocus.com/archive/1/482942/30/0/threaded
http://archives.neohapsis.com/archives/fulldisclosure/2007-10/0905.html
http://archives.neohapsis.com/archives/fulldisclosure/2007-10/0907.html
http://archives.neohapsis.com/archives/fulldisclosure/2007-10/0908.html
http://service.real.com/realplayer/security/10252007_player/en/

Solution :

Upgrade to RealPlayer 10.5 build 6.0.12.1662 / RealPlayer Enterprise
build 6.0.11.2160 or later. 

Note that the vendor's advisory states that version numbers for
RealPlayer 10.5 are not sequential. 

Risk factor : 

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("realplayer_detect.nasl");
  script_require_keys("SMB/RealPlayer/Product", "SMB/RealPlayer/Version");

  exit(0);
}


prod = get_kb_item("SMB/RealPlayer/Product");
if (!prod) exit(0);


version = get_kb_item("SMB/RealPlayer/Version");
if (!version) exit(0);

ver = split(version, sep:'.', keep:FALSE);
for (i=0; i<max_index(ver); i++)
  ver[i] = int(ver[i]);


vuln = FALSE;
if ("RealPlayer" == prod)
{
  # nb: version numbers ARE NOT NECESSARILY SEQUENTIAL!
  if (
    ver[0] < 6 ||
    (
      ver[0] == 6 && ver[1] == 0 && 
      (
        ver[2] < 12 ||
        (
          ver[2] == 12 && 
          (
            ver[3] <= 1578 ||
            ver[3] == 1698 ||
            ver[3] == 1741
          )
        )
      )
    )
  ) vuln = TRUE;
}
else if ("RealPlayer Enterprise" == prod)
{
  # Fix is 6.0.11.2160 per 
  # <http://service.real.com/realplayer/security/security/enterprise_102507.html>.
  if (
    ver[0] < 6 ||
    (
      ver[0] == 6 && ver[1] == 0 && 
      (
        ver[2] < 11 ||
        (ver[2] == 11 && ver[3] < 2160)
      )
    )
  ) vuln = TRUE;
}
else if ("RealOne Player" == prod)
{
  vuln = TRUE;
}


if (vuln) security_hole(get_kb_item("SMB/transport"));
