#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(17172);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CVE-2004-1184", "CVE-2004-1185", "CVE-2004-1186");

 name["english"] = "RHSA-2005-040: enscript";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  An updated enscript package that fixes several security issues is now
  available for Red Hat Enterprise Linux 4.

  This update has been rated as having low security impact by the Red Hat
  Security Response Team.

  GNU enscript converts ASCII files to PostScript.

  Enscript has the ability to interpret special escape sequences. A flaw was
  found in the handling of the epsf command used to insert inline EPS files
  into a document. An attacker could create a carefully crafted ASCII file
  which made use of the epsf pipe command in such a way that it could execute
  arbitrary commands if the file was opened with enscript by a victim. The
  Common Vulnerabilities and Exposures project (cve.mitre.org) has assigned
  the name CVE-2004-1184 to this issue.

  Additional flaws in Enscript were also discovered which can only be
  triggered by executing enscript with carefully crafted command line
  arguments. These flaws therefore only have a security impact if enscript
  is executed by other programs and passed untrusted data from remote users.
  The Common Vulnerabilities and Exposures project (cve.mitre.org) has
  assigned the names CVE-2004-1185 and CVE-2004-1186 to these issues.

  All users of enscript should upgrade to these updated packages, which
  contain backported patches to correct these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2005-040.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the enscript packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2005 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"enscript-1.6.1-28.3", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"enscript-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2004-1184", value:TRUE);
 set_kb_item(name:"CVE-2004-1185", value:TRUE);
 set_kb_item(name:"CVE-2004-1186", value:TRUE);
}

set_kb_item(name:"RHSA-2005-040", value:TRUE);
