#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23678);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2005-3011", "CVE-2006-4810");

 name["english"] = "RHSA-2006-0727: info";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  New Texinfo packages that fix various security vulnerabilities are now
  available.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  Texinfo is a documentation system that can produce both online information
  and printed output from a single source file.

  A buffer overflow flaw was found in Texinfo\'s texindex command. An attacker
  could construct a carefully crafted Texinfo file that could cause texindex
  to crash or possibly execute arbitrary code when opened. (CVE-2006-4810)

  A flaw was found in the way Texinfo\'s texindex command creates temporary
  files. A local user could leverage this flaw to overwrite files the user
  executing texindex has write access to. (CVE-2005-3011)

  Users of Texinfo should upgrade to these updated packages which contain
  backported patches and are not vulnerable to these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2006-0727.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the info packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"info-4.0b-3.el2.1", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"texinfo-4.0b-3.el2.1", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"info-4.5-3.el3.1", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"texinfo-4.5-3.el3.1", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"info-4.7-5.el4.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"texinfo-4.7-5.el4.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"info-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2005-3011", value:TRUE);
 set_kb_item(name:"CVE-2006-4810", value:TRUE);
}
if ( rpm_exists(rpm:"info-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2005-3011", value:TRUE);
 set_kb_item(name:"CVE-2006-4810", value:TRUE);
}
if ( rpm_exists(rpm:"info-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2005-3011", value:TRUE);
 set_kb_item(name:"CVE-2006-4810", value:TRUE);
}

set_kb_item(name:"RHSA-2006-0727", value:TRUE);
