#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23797);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-5989");

 name["english"] = "RHSA-2006-0746: mod_auth_kerb";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated mod_auth_kerb packages that fix a security flaw and a bug in
  multiple realm handling are now available for Red Hat Enterprise Linux 4.

  This update has been rated as having low security impact by the Red Hat
  Security Response Team.

  mod_auth_kerb is module for the Apache HTTP Server designed to
  provide Kerberos authentication over HTTP.

  An off by one flaw was found in the way mod_auth_kerb handles certain
  Kerberos authentication messages. A remote client could send a specially
  crafted authentication request which could crash an httpd child process
  (CVE-2006-5989).

  A bug in the handling of multiple realms configured using the
  "KrbAuthRealms" directive has also been fixed.

  All users of mod_auth_kerb should upgrade to these updated packages, which
  contain backported patches that resolve these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2006-0746.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mod_auth_kerb packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"mod_auth_kerb-5.0-1.3", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"mod_auth_kerb-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-5989", value:TRUE);
}

set_kb_item(name:"RHSA-2006-0746", value:TRUE);
