#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23798);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-6169", "CVE-2006-6235");

 name["english"] = "RHSA-2006-0754: gnupg";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated GnuPG packages that fix two security issues are now available.

  This update has been rated as having important security impact by the Red
  Hat Security Response Team.

  GnuPG is a utility for encrypting data and creating digital signatures.

  Tavis Ormandy discovered a stack overwrite flaw in the way GnuPG decrypts
  messages. An attacker could create carefully crafted message that could
  cause
  GnuPG to execute arbitrary code if a victim attempts to decrypt the
  message.
  (CVE-2006-6235)

  A heap based buffer overflow flaw was found in the way GnuPG constructs
  messages to be written to the terminal during an interactive session. An
  attacker could create a carefully crafted message which with user
  interaction
  could cause GnuPG to execute arbitrary code with the permissions of the
  user running GnuPG. (CVE-2006-6169)

  All users of GnuPG are advised to upgrade to this updated package, which
  contains a backported patch to correct these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2006-0754.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gnupg packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"gnupg-1.0.7-20", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gnupg-1.2.1-19", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"gnupg-1.2.6-8", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"gnupg-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2006-6169", value:TRUE);
 set_kb_item(name:"CVE-2006-6235", value:TRUE);
}
if ( rpm_exists(rpm:"gnupg-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2006-6169", value:TRUE);
 set_kb_item(name:"CVE-2006-6235", value:TRUE);
}
if ( rpm_exists(rpm:"gnupg-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-6169", value:TRUE);
 set_kb_item(name:"CVE-2006-6235", value:TRUE);
}

set_kb_item(name:"RHSA-2006-0754", value:TRUE);
