#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23961);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-6497", "CVE-2006-6498", "CVE-2006-6501", "CVE-2006-6502", "CVE-2006-6503", "CVE-2006-6504", "CVE-2006-6505");

 name["english"] = "RHSA-2006-0759: seamonkey";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated seamonkey packages that fix several security bugs are now available
  for Red Hat Enterprise Linux 2.1, 3, and 4.

  This update has been rated as having critical security impact by the Red
  Hat Security Response Team.

  SeaMonkey is an open source Web browser, advanced email and newsgroup
  client, IRC chat client, and HTML editor.

  Several flaws were found in the way SeaMonkey processes certain malformed
  Javascript code. A malicious web page could cause the execution of
  Javascript code in such a way that could cause SeaMonkey to crash or
  execute arbitrary code as the user running SeaMonkey. (CVE-2006-6498,
  CVE-2006-6501, CVE-2006-6502, CVE-2006-6503, CVE-2006-6504)

  Several flaws were found in the way SeaMonkey renders web pages. A
  malicious web page could cause the browser to crash or possibly execute
  arbitrary code as the user running SeaMonkey. (CVE-2006-6497)

  A heap based buffer overflow flaw was found in the way SeaMonkey Mail
  parses the Content-Type mail header. A malicious mail message could cause
  the SeaMonkey Mail client to crash or possibly execute arbitrary code as
  the user running SeaMonkey Mail. (CVE-2006-6505)

  Users of SeaMonkey are advised to upgrade to these erratum packages, which
  contain SeaMonkey version 1.0.7 that corrects these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2006-0759.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the seamonkey packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"seamonkey-1.0.7-0.1.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-chat-1.0.7-0.1.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-devel-1.0.7-0.1.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-dom-inspector-1.0.7-0.1.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-js-debugger-1.0.7-0.1.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-mail-1.0.7-0.1.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nspr-1.0.7-0.1.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nspr-devel-1.0.7-0.1.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nss-1.0.7-0.1.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nss-devel-1.0.7-0.1.el2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-1.0.7-0.1.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-chat-1.0.7-0.1.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-devel-1.0.7-0.1.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-dom-inspector-1.0.7-0.1.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-js-debugger-1.0.7-0.1.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-mail-1.0.7-0.1.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nspr-1.0.7-0.1.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nspr-devel-1.0.7-0.1.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nss-1.0.7-0.1.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nss-devel-1.0.7-0.1.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"devhelp-0.10-0.6.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"devhelp-devel-0.10-0.6.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-1.0.7-0.1.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-chat-1.0.7-0.1.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-devel-1.0.7-0.1.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-dom-inspector-1.0.7-0.1.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-js-debugger-1.0.7-0.1.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-mail-1.0.7-0.1.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nspr-1.0.7-0.1.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nspr-devel-1.0.7-0.1.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nss-1.0.7-0.1.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"seamonkey-nss-devel-1.0.7-0.1.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"seamonkey-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2006-6497", value:TRUE);
 set_kb_item(name:"CVE-2006-6498", value:TRUE);
 set_kb_item(name:"CVE-2006-6501", value:TRUE);
 set_kb_item(name:"CVE-2006-6502", value:TRUE);
 set_kb_item(name:"CVE-2006-6503", value:TRUE);
 set_kb_item(name:"CVE-2006-6504", value:TRUE);
 set_kb_item(name:"CVE-2006-6505", value:TRUE);
}
if ( rpm_exists(rpm:"seamonkey-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2006-6497", value:TRUE);
 set_kb_item(name:"CVE-2006-6498", value:TRUE);
 set_kb_item(name:"CVE-2006-6501", value:TRUE);
 set_kb_item(name:"CVE-2006-6502", value:TRUE);
 set_kb_item(name:"CVE-2006-6503", value:TRUE);
 set_kb_item(name:"CVE-2006-6504", value:TRUE);
 set_kb_item(name:"CVE-2006-6505", value:TRUE);
}
if ( rpm_exists(rpm:"seamonkey-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-6497", value:TRUE);
 set_kb_item(name:"CVE-2006-6498", value:TRUE);
 set_kb_item(name:"CVE-2006-6501", value:TRUE);
 set_kb_item(name:"CVE-2006-6502", value:TRUE);
 set_kb_item(name:"CVE-2006-6503", value:TRUE);
 set_kb_item(name:"CVE-2006-6504", value:TRUE);
 set_kb_item(name:"CVE-2006-6505", value:TRUE);
}

set_kb_item(name:"RHSA-2006-0759", value:TRUE);
