#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23962);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-6497", "CVE-2006-6498", "CVE-2006-6501", "CVE-2006-6502", "CVE-2006-6503", "CVE-2006-6504", "CVE-2006-6505");

 name["english"] = "RHSA-2006-0760: thunderbird";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated thunderbird packages that fix several security bugs are now
  available for Red Hat Enterprise Linux 4.

  This update has been rated as having critical security impact by the Red
  Hat Security Response Team.

  Mozilla Thunderbird is a standalone mail and newsgroup client.

  Several flaws were found in the way Thunderbird processes certain malformed
  Javascript code. A malicious web page could cause the execution of
  Javascript code in such a way that could cause Thunderbird to crash or
  execute arbitrary code as the user running Thunderbird. JavaScript support
  is disabled by default in Thunderbird; this issue is not exploitable
  without enabling JavaScript. (CVE-2006-6498, CVE-2006-6501, CVE-2006-6502,
  CVE-2006-6503, CVE-2006-6504)

  Several flaws were found in the way Thunderbird renders web pages. A
  malicious web page could cause the browser to crash or possibly execute
  arbitrary code as the user running Thunderbird. (CVE-2006-6497)

  A heap based buffer overflow flaw was found in the way Thunderbird parses
  the Content-Type mail header. A malicious mail message could cause the
  Thunderbird client to crash or possibly execute arbitrary code as the user
  running Thunderbird. (CVE-2006-6505)

  Users of Thunderbird are advised to apply this update, which contains
  Thunderbird version 1.5.0.9 that corrects these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2006-0760.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the thunderbird packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"thunderbird-1.5.0.9-0.1.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"thunderbird-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-6497", value:TRUE);
 set_kb_item(name:"CVE-2006-6498", value:TRUE);
 set_kb_item(name:"CVE-2006-6501", value:TRUE);
 set_kb_item(name:"CVE-2006-6502", value:TRUE);
 set_kb_item(name:"CVE-2006-6503", value:TRUE);
 set_kb_item(name:"CVE-2006-6504", value:TRUE);
 set_kb_item(name:"CVE-2006-6505", value:TRUE);
}

set_kb_item(name:"RHSA-2006-0760", value:TRUE);
