#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24211);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-4514");

 name["english"] = "RHSA-2007-0011: libgsf";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated libgsf packages that fix a buffer overflow flaw are now available.

  This update has been rated as having moderate security impact by the Red
  Hat
  Security Response Team.

  The GNOME Structured File Library is a utility library for reading and
  writing structured file formats.

  A heap based buffer overflow flaw was found in the way GNOME Structured
  File Library processes and certain OLE documents. If an person opened a
  specially crafted OLE file, it could cause the client application to crash
  or
  execute arbitrary code. (CVE-2006-4514)

  Users of GNOME Structured File Library should upgrade to these updated
  packages, which contain a backported patch that resolves this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0011.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libgsf packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libgsf-1.6.0-7", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libgsf-devel-1.6.0-7", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libgsf-1.10.1-2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libgsf-devel-1.10.1-2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"libgsf-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2006-4514", value:TRUE);
}
if ( rpm_exists(rpm:"libgsf-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-4514", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0011", value:TRUE);
