#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24212);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-2935", "CVE-2006-4997");

 name["english"] = "RHSA-2007-0013:   kernel";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated kernel packages that fix a number of security issues as well as
  other bugs are now available for Red Hat Enterprise Linux 2.1 (32 bit
  architectures)

  This security advisory has been rated as having moderate security impact by
  the Red Hat Security Response Team.

  The Linux kernel handles the basic functions of the operating system.

  These new kernel packages contain fixes for the security issues described
  below:

  * a flaw in the ATM subsystem affecting systems with installed ATM hardware
  and configured ATM support that allowed a remote user to cause a denial of
  service (panic) by accessing socket buffer memory after it has been freed
  (CVE-2006-4997, Moderate)

  * a flaw in the DVD handling of the CDROM driver that could be used
  together with a custom built USB device to gain root privileges
  (CVE-2006-2935, Moderate)

  In addition to the security issues described above, the following bugs are
  also addressed:

  * a potential overflow condition when reading /proc/devices
  * uninitialized memory in cdrom_init() that can lead to a crash at install
  time
  * a potential page corruption bug in /proc/kcore
  * a race condition when reading vmalloc()ed regions via /proc/kcore

  All Red Hat Enterprise Linux 2.1 users are advised to upgrade their kernels
  to these updated packages, which contain backported fixes to correct these
  issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0013.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the   kernel packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"  kernel-2.4.9-e.71.athlon.rpm               2717477b65b013f4341e505b05cc2311", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"  kernel-2.4.9-e.71.i686.rpm                 cfefd56a803b58d4fc0f7a9e5cbde814", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kernel-BOOT-2.4.9-e.71", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"  kernel-debug-2.4.9-e.71.i686.rpm           84208388bdb8fed407d4d54788df3714", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kernel-doc-2.4.9-e.71", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"  kernel-enterprise-2.4.9-e.71.i686.rpm      83c1fd68611302157486110a73cb27dc", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kernel-headers-2.4.9-e.71", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"  kernel-smp-2.4.9-e.71.athlon.rpm           a4beb1aa891f3dab4b2db9bd33ca89dc", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"  kernel-smp-2.4.9-e.71.i686.rpm             1697645d1da8fe51a74fff9be90136dd", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kernel-source-2.4.9-e.71", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"  kernel-summit-2.4.9-e.71.i686.rpm          cc8345617fc9877ea529c3a7dc37ab83", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"  kernel-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2006-2935", value:TRUE);
 set_kb_item(name:"CVE-2006-4997", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0013", value:TRUE);
