#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24315);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-4538", "CVE-2006-4813", "CVE-2006-4814", "CVE-2006-5174", "CVE-2006-5619", "CVE-2006-5751", "CVE-2006-5753", "CVE-2006-5754", "CVE-2006-5757", "CVE-2006-5823", "CVE-2006-6053", "CVE-2006-6054", "CVE-2006-6056", "CVE-2006-6106", "CVE-2006-6535");

 name["english"] = "RHSA-2007-0014: kernel";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated kernel packages that fix several security issues in the Red Hat
  Enterprise Linux 4 kernel are now available.

  This security advisory has been rated as having important security impact
  by the Red Hat Security Response Team.

  The Linux kernel handles the basic functions of the operating system.

  These new kernel packages contain fixes for various security issues.

  All Red Hat Enterprise Linux 4 users are advised to upgrade their kernels
  to the packages associated with their machine architecture and
  configurations as listed in this erratum.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0014.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the   kernel packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"kernel-2.6.9-42.0.8.EL", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kernel-devel-2.6.9-42.0.8.EL", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kernel-doc-2.6.9-42.0.8.EL", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kernel-hugemem-2.6.9-42.0.8.EL", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kernel-hugemem-devel-2.6.9-42.0.8.EL", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kernel-smp-2.6.9-42.0.8.EL", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"kernel-smp-devel-2.6.9-42.0.8.EL", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"kernel-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-4538", value:TRUE);
 set_kb_item(name:"CVE-2006-4813", value:TRUE);
 set_kb_item(name:"CVE-2006-4814", value:TRUE);
 set_kb_item(name:"CVE-2006-5174", value:TRUE);
 set_kb_item(name:"CVE-2006-5619", value:TRUE);
 set_kb_item(name:"CVE-2006-5751", value:TRUE);
 set_kb_item(name:"CVE-2006-5753", value:TRUE);
 set_kb_item(name:"CVE-2006-5754", value:TRUE);
 set_kb_item(name:"CVE-2006-5757", value:TRUE);
 set_kb_item(name:"CVE-2006-5823", value:TRUE);
 set_kb_item(name:"CVE-2006-6053", value:TRUE);
 set_kb_item(name:"CVE-2006-6054", value:TRUE);
 set_kb_item(name:"CVE-2006-6056", value:TRUE);
 set_kb_item(name:"CVE-2006-6106", value:TRUE);
 set_kb_item(name:"CVE-2006-6535", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0014", value:TRUE);
