#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24896);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-0238", "CVE-2007-0239", "CVE-2007-1466");

 name["english"] = "RHSA-2007-0033: openoffice.org";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated openoffice.org packages to correct security issues are now
  available for Red Hat Enterprise Linux 3 and 4.

  This update has been rated as having important security impact by the Red
  Hat Security Response Team.

  OpenOffice.org is an office productivity suite that includes desktop
  applications such as a word processor, spreadsheet, presentation manager,
  formula editor, and drawing program.

  iDefense reported an integer overflow flaw in libwpd, a library used
  internally to OpenOffice.org for handling Word Perfect documents. An
  attacker could create a carefully crafted Word Perfect file that could
  cause OpenOffice.org to crash or possibly execute arbitrary code if the
  file was opened by a victim. (CVE-2007-1466)

  John Heasman discovered a stack overflow in the StarCalc parser in
  OpenOffice.org. An attacker could create a carefully crafted StarCalc file
  that could cause OpenOffice.org to crash or possibly execute arbitrary code
  if the file was opened by a victim. (CVE-2007-0238)

  Flaws were discovered in the way OpenOffice.org handled hyperlinks. An
  attacker could create an OpenOffice.org document which could run commands
  if a victim opened the file and clicked on a malicious hyperlink.
  (CVE-2007-0239)

  All users of OpenOffice.org are advised to upgrade to these updated
  packages, which contain backported fixes for these issues.

  Red Hat would like to thank Fridrich Štrba for alerting us to the issue
  CVE-2007-1466 and providing a patch, and John Heasman for
  CVE-2007-0238.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0033.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the openoffice.org packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"openoffice.org-1.1.2-38.2.0.EL3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"openoffice.org-i18n-1.1.2-38.2.0.EL3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"openoffice.org-libs-1.1.2-38.2.0.EL3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"openoffice.org-1.1.5-10.6.0.EL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"openoffice.org-i18n-1.1.5-10.6.0.EL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"openoffice.org-kde-1.1.5-10.6.0.EL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"openoffice.org-libs-1.1.5-10.6.0.EL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"openoffice.org-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-0238", value:TRUE);
 set_kb_item(name:"CVE-2007-0239", value:TRUE);
 set_kb_item(name:"CVE-2007-1466", value:TRUE);
}
if ( rpm_exists(rpm:"openoffice.org-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-0238", value:TRUE);
 set_kb_item(name:"CVE-2007-0239", value:TRUE);
 set_kb_item(name:"CVE-2007-1466", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0033", value:TRUE);
