#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25312);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-0002", "CVE-2007-1466");

 name["english"] = "RHSA-2007-0055: libwpd";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated libwpd packages to correct a security issue are now available for
  Red Hat Enterprise Linux 5.

  This update has been rated as having important security impact by the Red
  Hat Security Response Team.

  libwpd is a library for reading and converting Word Perfect documents.

  iDefense reported several overflow bugs in libwpd. An attacker could
  create a carefully crafted Word Perfect file that could cause an
  application linked with libwpd, such as OpenOffice, to crash or possibly
  execute arbitrary code if the file was opened by a victim. (CVE-2007-0002)

  All users are advised to upgrade to these updated packages, which contain a
  backported fix for this issue.

  Red Hat would like to thank Fridrich Štrba for alerting us to these issues
  and providing a patch.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0055.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libwpd packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libwpd-0.8.7-3.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libwpd-tools-0.8.7-3.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"libwpd-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-0002", value:TRUE);
 set_kb_item(name:"CVE-2007-1466", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0055", value:TRUE);
