#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25314);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-0452");

 name["english"] = "RHSA-2007-0061: samba";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated samba packages that fix a denial of service vulnerability are now
  available for Red Hat Enterprise Linux 5.

  This update has been rated as having important security impact by the Red
  Hat Security Response Team.

  Samba provides file and printer sharing services to SMB/CIFS clients.

  A denial of service flaw was found in Samba\'s smbd daemon process. An
  authenticated user could send a specially crafted request which would cause
  a smbd child process to enter an infinite loop condition. By opening
  multiple CIFS sessions, an attacker could exhaust system resources
  (CVE-2007-0452).

  Users of Samba should update to these packages, which contain a
  backported patch to correct this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0061.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the samba packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"samba-3.0.23c-2.el5.2", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-client-3.0.23c-2.el5.2", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-common-3.0.23c-2.el5.2", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-swat-3.0.23c-2.el5.2", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-3.0.23c-2.el5.2", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-client-3.0.23c-2.el5.2", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-common-3.0.23c-2.el5.2", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-swat-3.0.23c-2.el5.2", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"samba-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-0452", value:TRUE);
}
if ( rpm_exists(rpm:"samba-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-0452", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0061", value:TRUE);
