#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25238);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-6899");

 name["english"] = "RHSA-2007-0065: bluez";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated bluez-utils packages that fix a security flaw are now available for
  Red Hat Enterprise Linux 4.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  The bluez-utils package contains Bluetooth daemons and utilities.

  A flaw was found in the Bluetooth HID daemon (hidd). A remote attacker
  would have been able to inject keyboard and mouse events via a Bluetooth
  connection without any authorization. (CVE-2006-6899)

  Note that Red Hat Enterprise Linux does not come with the Bluetooth HID
  daemon enabled by default.

  Users of bluez-utils are advised to upgrade to these updated packages,
  which
  contains a backported patch to correct this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0065.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the bluez packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"bluez-utils-2.10-2.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"bluez-utils-cups-2.10-2.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"bluez-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-6899", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0065", value:TRUE);
