#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24696);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-0451");

 name["english"] = "RHSA-2007-0074: spamassassin";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated spamassassin packages that fix a security issue are now available
  for Red Hat Enterprise Linux 4.

  This update has been rated as having important security impact by the Red
  Hat Security Response Team.

  SpamAssassin provides a way to reduce unsolicited commercial email (spam)
  from incoming email.

  A flaw was found in the way SpamAssassin processes HTML email containing
  URIs. A carefully crafted mail message could cause SpamAssassin to consume
  significant resources. If a number of these messages are sent, this could
  lead to a denial of service, potentially delaying or preventing the
  delivery of email.
  (CVE-2007-0451)

  Users of SpamAssassin should upgrade to these updated packages which
  contain version 3.1.8 which is not vulnerable to these issues.

  This is an upgrade from SpamAssassin version 3.0.6 to 3.1.8, which contains
  many bug fixes and spam detection enhancements. Further details are
  available in the SpamAssassin 3.1 changelog and upgrade guide.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0074.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the spamassassin packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"spamassassin-3.1.8-2.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"spamassassin-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-0451", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0074", value:TRUE);
