#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25322);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-1003");

 name["english"] = "RHSA-2007-0127: xorg";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated X.org X11 server packages that fix a security issue are now
  available for Red Hat Enterprise Linux 5.

  This update has been rated as having important security impact by the Red
  Hat Security Response Team.

  X.org is an open source implementation of the X Window System. It provides
  the basic low-level functionality that full-fledged graphical user
  interfaces are designed upon.

  iDefense reported an integer overflow flaw in the X.org X11 server XC-MISC
  extension. A malicious authorized client could exploit this issue to cause
  a denial of service (crash) or potentially execute arbitrary code with root
  privileges on the X.org server. (CVE-2007-1003)

  Users of the X.org X11 server should upgrade to these updated packages,
  which contain a backported patch and is not vulnerable to this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0127.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the xorg packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"xorg-x11-server-Xdmx-1.1.1-48.13.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"xorg-x11-server-Xephyr-1.1.1-48.13.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"xorg-x11-server-Xnest-1.1.1-48.13.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"xorg-x11-server-Xorg-1.1.1-48.13.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"xorg-x11-server-Xvfb-1.1.1-48.13.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"xorg-x11-server-sdk-1.1.1-48.13.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"xorg-x11-server-Xdmx-1.1.1-48.13.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"xorg-x11-server-Xephyr-1.1.1-48.13.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"xorg-x11-server-Xnest-1.1.1-48.13.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"xorg-x11-server-Xorg-1.1.1-48.13.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"xorg-x11-server-Xvfb-1.1.1-48.13.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"xorg-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-1003", value:TRUE);
}
if ( rpm_exists(rpm:"xorg-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-1003", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0127", value:TRUE);
