#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25327);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-1002");

 name["english"] = "RHSA-2007-0158: evolution";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated evolution packages that fix a format string bug are now available
  for Red Hat Enterprise Linux 5.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  Evolution is the GNOME collection of personal information management (PIM)
  tools.

  A format string bug was found in the way Evolution parsed the category field
  in a memo. If a user tried to save and then view a carefully crafted memo,
  arbitrary code may be executed as the user running Evolution. (CVE-2007-1002)

  This flaw did not affect the versions of Evolution shipped with Red Hat
  Enterprise Linux 2.1, 3, or 4.

  All users of Evolution should upgrade to these updated packages, which
  contain a backported patch which resolves this issue.

  Red Hat would like to thank Ulf Härnhammar of Secunia Research for
  reporting this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0158.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the evolution packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"evolution-2.8.0-33.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"evolution-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-1002", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0158", value:TRUE);
