#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25136);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2005-3183");

 name["english"] = "RHSA-2007-0208: w";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated w3c-libwww packages that fix a security issue and a bug are now
  available.

  This update has been rated as having low security impact by the Red Hat
  Security Response Team.

  w3c-libwww is a general-purpose web library.

  Several buffer overflow flaws in w3c-libwww were found. If a client
  application that uses w3c-libwww connected to a malicious HTTP server, it
  could trigger an out of bounds memory access, causing the client
  application to crash (CVE-2005-3183).

  This updated version of w3c-libwww also fixes an issue when computing MD5
  sums on a 64 bit machine.

  Users of w3c-libwww should upgrade to these updated packages, which contain
  backported patches to correct these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0208.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the w packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"w3c-libwww-5.4.0-10.1.RHEL4.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"w3c-libwww-apps-5.4.0-10.1.RHEL4.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"w3c-libwww-devel-5.4.0-10.1.RHEL4.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"w-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2005-3183", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0208", value:TRUE);
