#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25139);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-7108");

 name["english"] = "RHSA-2007-0235: util";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  An updated util-linux package that corrects a security issue and fixes
  several bugs is now available.

  This update has been rated as having low security impact by the Red Hat
  Security Response Team.

  The util-linux package contains a collection of basic system utilities.

  A flaw was found in the way the login process handled logins which did not
  require authentication. Certain processes which conduct their own
  authentication could allow a remote user to bypass intended access policies
  which would normally be enforced by the login process. (CVE-2006-7108)

  This update also fixes the following bugs:

  * The partx, addpart and delpart commands were not documented.

  * The "umount -l" command did not work on hung NFS mounts with cached data.

  * The mount command did not mount NFS V3 share where sec=none was
  specified.

  * The mount command did not read filesystem LABEL from unpartitioned disks.

  * The mount command did not recognize labels on VFAT filesystems.

  * The fdisk command did not support 4096 sector size for the "-b" option.

  * The mount man page did not list option "mand" or information about
  /etc/mtab limitations.

  All users of util-linux should upgrade to these updated packages, which
  contain backported patches to correct these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0235.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the util packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"util-linux-2.12a-16.EL4.25", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"util-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-7108", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0235", value:TRUE);
