#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25140);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-1058");

 name["english"] = "RHSA-2007-0244: busybox";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated busybox packages that fix a security issue are now available.

  This update has been rated as having low security impact by the Red Hat
  Security Response Team.

  Busybox is a single binary which includes versions of a large number of
  system commands, including a shell. This package can be useful for
  recovering from certain types of system failures.

  BusyBox did not use a salt when generating passwords. This made it
  easier for local users to guess passwords from a stolen password file.
  (CVE-2006-1058)

  All users of busybox are advised to upgrade to these updated packages,
  which contain a patch to resolve this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0244.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the busybox packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"busybox-1.00.rc1-7.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"busybox-anaconda-1.00.rc1-7.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"busybox-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-1058", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0244", value:TRUE);
