#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25143);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2005-2666");

 name["english"] = "RHSA-2007-0257: openssh";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated openssh packages that fix a security issue and various bugs are now
  available.

  This update has been rated as having low security impact by the Red Hat
  Security Response Team.

  OpenSSH is OpenBSD\'s SSH (Secure SHell) protocol implementation. This
  package includes the core files necessary for both the OpenSSH client and
  server.

  OpenSSH stores hostnames, IP addresses, and keys in plaintext in the
  known_hosts file. A local attacker that has already compromised a user\'s
  SSH account could use this information to generate a list of additional
  targets that are likely to have the same password or key. (CVE-2005-2666)

  The following bugs have also been fixed in this update:

  * The ssh client could abort the running connection when the server
  application generated a large output at once.

  * When \'X11UseLocalhost\' option was set to \'no\' on systems with IPv6
  networking enabled, the X11 forwarding socket listened only for IPv6
  connections.

  * When the privilege separation was enabled in /etc/ssh/sshd_config, some
  log messages in the system log were duplicated and also had timestamps from
  an incorrect timezone.

  All users of openssh should upgrade to these updated packages, which
  contain backported patches to correct these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0257.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the openssh packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"openssh-3.9p1-8.RHEL4.20", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"openssh-askpass-3.9p1-8.RHEL4.20", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"openssh-askpass-gnome-3.9p1-8.RHEL4.20", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"openssh-clients-3.9p1-8.RHEL4.20", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"openssh-server-3.9p1-8.RHEL4.20", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"openssh-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2005-2666", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0257", value:TRUE);
