#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25330);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-1841");

 name["english"] = "RHSA-2007-0342: ipsec";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated ipsec-tools packages that fix a denial of service flaw in racoon
  are now available for Red Hat Enterprise Linux 5.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  The ipsec-tools package is used in conjunction with the IPsec functionality
  in the linux kernel and includes racoon, an IKEv1 keying daemon.

  A denial of service flaw was found in the ipsec-tools racoon daemon. It was
  possible for a remote attacker, with knowledge of an existing ipsec tunnel,
  to terminate the ipsec connection between two machines. (CVE-2007-1841)

  Users of ipsec-tools should upgrade to these updated packages, which
  contain a backported patch that resolves this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0342.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the ipsec packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"ipsec-tools-0.6.5-8.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"ipsec-tools-0.6.5-8.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"ipsec-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-1841", value:TRUE);
}
if ( rpm_exists(rpm:"ipsec-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-1841", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0342", value:TRUE);
