#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25267);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CVE-2007-1856");

 name["english"] = "RHSA-2007-0345: vixie";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated vixie-cron packages that fix a denial of service issue are now
  available.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  The vixie-cron package contains the Vixie version of cron. Cron is a
  standard UNIX daemon that runs specified programs at scheduled times.

  Raphael Marichez discovered a denial of service bug in the way vixie-cron
  verifies crontab file integrity. A local user with the ability to create a
  hardlink to /etc/crontab can prevent vixie-cron from executing certain
  system cron jobs. (CVE-2007-1856)

  All users of vixie-cron should upgrade to these updated packages, which
  contain a backported patch to correct this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0345.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the vixie packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"vixie-cron-4.1-70.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"vixie-cron-4.1-19.EL3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"vixie-cron-4.1-47.EL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"vixie-cron-4.1-70.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"vixie-cron-4.1-19.EL3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"vixie-cron-4.1-47.EL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"vixie-cron-4.1-19.EL3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"vixie-cron-4.1-47.EL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"vixie-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-1856", value:TRUE);
}
if ( rpm_exists(rpm:"vixie-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-1856", value:TRUE);
}
if ( rpm_exists(rpm:"vixie-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-1856", value:TRUE);
}
if ( rpm_exists(rpm:"vixie-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-1856", value:TRUE);
}
if ( rpm_exists(rpm:"vixie-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-1856", value:TRUE);
}
if ( rpm_exists(rpm:"vixie-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-1856", value:TRUE);
}
if ( rpm_exists(rpm:"vixie-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-1856", value:TRUE);
}
if ( rpm_exists(rpm:"vixie-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-1856", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0345", value:TRUE);
