#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25239);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CVE-2007-2446", "CVE-2007-2447");

 name["english"] = "RHSA-2007-0354: samba";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated samba packages that fix several security flaws are now available.

  This update has been rated as having critical security impact by the Red
  Hat Security Response Team.

  Samba provides file and printer sharing services to SMB/CIFS clients.

  Various bugs were found in NDR parsing, used to decode MS-RPC requests in
  Samba. A remote attacker could have sent carefully crafted requests
  causing a heap overflow, which may have led to the ability to execute
  arbitrary code on the server. (CVE-2007-2446)

  Unescaped user input parameters were being passed as arguments to /bin/sh.
  A remote, authenticated, user could have triggered this flaw and executed
  arbitrary code on the server. Additionally, on Red Hat Enterprise Linux 5
  only, this flaw could be triggered by a remote unauthenticated user if
  Samba was configured to use the non-default "username map script" option.
  (CVE-2007-2447)

  Users of Samba should upgrade to these packages, which contain backported
  patches to correct these issues. After upgrading, Samba should be
  restarted using "service smb restart"

  On Red Hat Enterprise Linux 5 the impact of these issues is reduced as
  Samba is constrained by the default SELinux "targeted" policy.

  Red Hat would like to thank the Samba developers, TippingPoint, and
  iDefense for reporting these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0354.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the samba packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"samba-3.0.23c-2.el5.2.0.2", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-client-3.0.23c-2.el5.2.0.2", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-common-3.0.23c-2.el5.2.0.2", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-swat-3.0.23c-2.el5.2.0.2", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-2.2.12-1.21as.6", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-client-2.2.12-1.21as.6", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-common-2.2.12-1.21as.6", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-swat-2.2.12-1.21as.6", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-3.0.9-1.3E.13.2", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-client-3.0.9-1.3E.13.2", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-common-3.0.9-1.3E.13.2", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-swat-3.0.9-1.3E.13.2", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-3.0.10-1.4E.12.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-client-3.0.10-1.4E.12.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-common-3.0.10-1.4E.12.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-swat-3.0.10-1.4E.12.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-3.0.23c-2.el5.2.0.2", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-client-3.0.23c-2.el5.2.0.2", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-common-3.0.23c-2.el5.2.0.2", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-swat-3.0.23c-2.el5.2.0.2", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-2.2.12-1.21as.6", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-client-2.2.12-1.21as.6", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-common-2.2.12-1.21as.6", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-swat-2.2.12-1.21as.6", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-3.0.10-1.4E.12.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-client-3.0.10-1.4E.12.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-common-3.0.10-1.4E.12.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-swat-3.0.10-1.4E.12.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-2.2.12-1.21as.6", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-client-2.2.12-1.21as.6", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-common-2.2.12-1.21as.6", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-swat-2.2.12-1.21as.6", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-3.0.10-1.4E.12.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-client-3.0.10-1.4E.12.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-common-3.0.10-1.4E.12.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"samba-swat-3.0.10-1.4E.12.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"samba-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-2446", value:TRUE);
 set_kb_item(name:"CVE-2007-2447", value:TRUE);
}
if ( rpm_exists(rpm:"samba-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-2446", value:TRUE);
 set_kb_item(name:"CVE-2007-2447", value:TRUE);
}
if ( rpm_exists(rpm:"samba-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-2446", value:TRUE);
 set_kb_item(name:"CVE-2007-2447", value:TRUE);
}
if ( rpm_exists(rpm:"samba-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-2446", value:TRUE);
 set_kb_item(name:"CVE-2007-2447", value:TRUE);
}
if ( rpm_exists(rpm:"samba-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-2446", value:TRUE);
 set_kb_item(name:"CVE-2007-2447", value:TRUE);
}
if ( rpm_exists(rpm:"samba-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-2446", value:TRUE);
 set_kb_item(name:"CVE-2007-2447", value:TRUE);
}
if ( rpm_exists(rpm:"samba-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-2446", value:TRUE);
 set_kb_item(name:"CVE-2007-2447", value:TRUE);
}
if ( rpm_exists(rpm:"samba-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-2446", value:TRUE);
 set_kb_item(name:"CVE-2007-2447", value:TRUE);
}
if ( rpm_exists(rpm:"samba-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-2446", value:TRUE);
 set_kb_item(name:"CVE-2007-2447", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0354", value:TRUE);
