#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25404);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-5297", "CVE-2007-1558", "CVE-2007-2683");

 name["english"] = "RHSA-2007-0386: mutt";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  An updated mutt package that fixes several security bugs is now available
  for
  Red Hat Enterprise Linux 3, 4 and 5.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  Mutt is a text-mode mail user agent.

  A flaw was found in the way Mutt used temporary files on NFS file systems.
  Due to an implementation issue in the NFS protocol, Mutt was not able to
  exclusively open a new file. A local attacker could conduct a
  time-dependent attack and possibly gain access to e-mail attachments opened
  by a victim. (CVE-2006-5297)

  A flaw was found in the way Mutt processed certain APOP authentication
  requests. By sending certain responses when mutt attempted to authenticate
  against an APOP server, a remote attacker could potentially acquire certain
  portions of a user\'s authentication credentials. (CVE-2007-1558)

  A flaw was found in the way Mutt handled certain characters in gecos fields
  which could lead to a buffer overflow. The gecos field is an entry in the
  password database typically used to record general information about the
  user. A local attacker could give themselves a carefully crafted "Real
  Name" which could execute arbitrary code if a victim uses Mutt and expands
  the attackers alias. (CVE-2007-2683)

  All users of mutt should upgrade to this updated package, which
  contains a backported patches to correct these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0386.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mutt packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"mutt-1.4.2.2-3.0.2.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mutt-1.4.1-5.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mutt-1.4.1-12.0.3.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mutt-1.4.2.2-3.0.2.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mutt-1.4.1-5.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mutt-1.4.1-12.0.3.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mutt-1.4.1-5.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mutt-1.4.1-12.0.3.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"mutt-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2006-5297", value:TRUE);
 set_kb_item(name:"CVE-2007-1558", value:TRUE);
 set_kb_item(name:"CVE-2007-2683", value:TRUE);
}
if ( rpm_exists(rpm:"mutt-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2006-5297", value:TRUE);
 set_kb_item(name:"CVE-2007-1558", value:TRUE);
 set_kb_item(name:"CVE-2007-2683", value:TRUE);
}
if ( rpm_exists(rpm:"mutt-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-5297", value:TRUE);
 set_kb_item(name:"CVE-2007-1558", value:TRUE);
 set_kb_item(name:"CVE-2007-2683", value:TRUE);
}
if ( rpm_exists(rpm:"mutt-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2006-5297", value:TRUE);
 set_kb_item(name:"CVE-2007-1558", value:TRUE);
 set_kb_item(name:"CVE-2007-2683", value:TRUE);
}
if ( rpm_exists(rpm:"mutt-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2006-5297", value:TRUE);
 set_kb_item(name:"CVE-2007-1558", value:TRUE);
 set_kb_item(name:"CVE-2007-2683", value:TRUE);
}
if ( rpm_exists(rpm:"mutt-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-5297", value:TRUE);
 set_kb_item(name:"CVE-2007-1558", value:TRUE);
 set_kb_item(name:"CVE-2007-2683", value:TRUE);
}
if ( rpm_exists(rpm:"mutt-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2006-5297", value:TRUE);
 set_kb_item(name:"CVE-2007-1558", value:TRUE);
 set_kb_item(name:"CVE-2007-2683", value:TRUE);
}
if ( rpm_exists(rpm:"mutt-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2006-5297", value:TRUE);
 set_kb_item(name:"CVE-2007-1558", value:TRUE);
 set_kb_item(name:"CVE-2007-2683", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0386", value:TRUE);
