#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25364);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-2799");

 name["english"] = "RHSA-2007-0391: file";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  An updated file package that fixes a security flaw is now available for Red
  Hat Enterprise Linux 4 and 5.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  The file command is used to identify a particular file according to the
  type of data contained by the file.

  The fix for CVE-2007-1536 introduced a new integer underflow flaw in the
  file utility. An attacker could create a carefully crafted file which, if
  examined by a victim using the file utility, could lead to arbitrary code
  execution. (CVE-2007-2799)

  This issue did not affect the version of the file utility distributed with
  Red Hat Enterprise Linux 2.1 or 3.

  Users should upgrade to this erratum package, which contain a backported
  patch to correct this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0391.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the file packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"file-4.17-9.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"file-4.10-3.0.2.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"file-4.17-9.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"file-4.10-3.0.2.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"file-4.10-3.0.2.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"file-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-2799", value:TRUE);
}
if ( rpm_exists(rpm:"file-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-2799", value:TRUE);
}
if ( rpm_exists(rpm:"file-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-2799", value:TRUE);
}
if ( rpm_exists(rpm:"file-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-2799", value:TRUE);
}
if ( rpm_exists(rpm:"file-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-2799", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0391", value:TRUE);
