#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25523);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-3099", "CVE-2007-3100");

 name["english"] = "RHSA-2007-0497: iscsi";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated iscsi-initiator-utils packages that fix a security flaw in
  open-iscsi are now available for Red Hat Enterprise Linux 5.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  The iscsi package provides the server daemon for the iSCSI protocol, as
  well as the utility programs used to manage it. iSCSI is a protocol for
  distributed disk access using SCSI commands sent over Internet Protocol
  networks.

  Olaf Kirch discovered two flaws in open-iscsi. A local attacker could use
  these flaws to cause the server daemon to stop responding, leading to a
  denial of service. (CVE-2007-3099, CVE-2007-3100).

  All users of open-iscsi should upgrade to this updated package which
  resolves these issues.

  Note: This issue did not affect Red Hat Enterprise Linux 2.1, 3, or 4.
  open-iscsi is available in Red Hat Enterprise Linux 5 as a Technology
  Preview.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0497.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the iscsi packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"iscsi-initiator-utils-6.2.0.742-0.6.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"iscsi-initiator-utils-6.2.0.742-0.6.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"iscsi-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-3099", value:TRUE);
 set_kb_item(name:"CVE-2007-3100", value:TRUE);
}
if ( rpm_exists(rpm:"iscsi-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-3099", value:TRUE);
 set_kb_item(name:"CVE-2007-3100", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0497", value:TRUE);
