#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25540);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CVE-2006-4168");

 name["english"] = "RHSA-2007-0501: libexif";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated libexif packages that fix an integer overflow flaw are now
  available for Red Hat Enterprise Linux 4 and 5.

  This update has been rated as having moderate security impact by the Red Hat
  Security Response Team.

  The libexif package contains the EXIF library. Applications use this
  library to parse EXIF image files.

  An integer overflow flaw was found in the way libexif parses EXIF image
  tags. If a victim opens a carefully crafted EXIF image file it could cause
  the application linked against libexif to execute arbitrary code or crash.
  (CVE-2007-4168)

  Users of libexif should upgrade to these updated packages, which contain a
  backported patch and are not vulnerable to this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0501.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libexif packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"libexif-0.6.13-4.0.2.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libexif-devel-0.6.13-4.0.2.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libexif-0.5.12-5.1.0.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libexif-devel-0.5.12-5.1.0.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libexif-0.6.13-4.0.2.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libexif-0.5.12-5.1.0.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libexif-devel-0.5.12-5.1.0.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libexif-0.5.12-5.1.0.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"libexif-devel-0.5.12-5.1.0.2", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"libexif-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-4168", value:TRUE);
}
if ( rpm_exists(rpm:"libexif-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-4168", value:TRUE);
}
if ( rpm_exists(rpm:"libexif-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-4168", value:TRUE);
}
if ( rpm_exists(rpm:"libexif-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-4168", value:TRUE);
}
if ( rpm_exists(rpm:"libexif-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-4168", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0501", value:TRUE);
