#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27830);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-4570");

 name["english"] = "RHSA-2007-0542: mcstrans";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  An updated mcstrans package that fixes a security issue and a bug is now
  available.

  This update has been rated as having low security impact by the Red Hat
  Security Response Team.

  mcstrans is the translation daemon used on SELinux machines to translate
  program context into human readable form.

  An algorithmic complexity weakness was found in the way the mcstrans daemon
  handled ranges of compartments in sensitivity labels. A local user could
  trigger this flaw causing mctransd to temporarily stop responding to other
  requests; a partial denial of service. (CVE-2007-4570)

  This update also fixes a problem where the mcstrans daemon was preventing
  SSH connections into an SELinux box, that was running a Multi-Level
  Security (MLS) Policy with multiple categories.

  Users of mcstrans are advised to upgrade to this updated package, which
  resolves this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0542.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mcstrans packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"mcstrans-0.2.6-1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mcstrans-0.2.6-1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"mcstrans-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-4570", value:TRUE);
}
if ( rpm_exists(rpm:"mcstrans-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-4570", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0542", value:TRUE);
