#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25623);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-3374");

 name["english"] = "RHSA-2007-0559: cman";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated cman packages that correct a security issue are now available for
  Red Hat Enterprise Linux 5.

  This update has been rated as having important security impact by the Red
  Hat Security Response Team.

  cman is the Red Hat Cluster Manager.

  A flaw was found in the cman daemon. A local attacker could connect to the
  cman daemon and trigger a static buffer overflow leading to a denial of
  service or, potentially, an escalation of privileges. (CVE-2007-3374)

  Users of Cluster Manager should upgrade to these updated packages, which
  contain a backported patch to correct this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0559.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the cman packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"cman-2.0.64-1.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"cman-devel-2.0.64-1.0.1.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"cman-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-3374", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0559", value:TRUE);
