#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27832);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-4129");

 name["english"] = "RHSA-2007-0631: coolkey";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated coolkey packages that fix a security issue and various bugs are now
  available for Red Hat Enterprise Linux 5.

  This update has been rated as having low security impact by the Red
  Hat Security Response Team.

  coolkey contains the driver support for the CoolKey and Common Access Card
  (CAC) Smart Card products. The CAC is used by the U.S. Government.

  Steve Grubb discovered a flaw in the way coolkey created a temporary
  directory. A local attacker could perform a symlink attack and cause
  arbitrary files to be overwritten. (CVE-2007-4129)

  In addition, the updated packages contain fixes for the following bugs in
  the CAC Smart Card support:

  * CAC Smart Cards can have from 1 to 3 certificates. The coolkey driver,
  however, was not recognizing cards if they had less than 3 certificates.

  * logging into a CAC Smart Card token with a new application would cause
  other, already authenticated, applications to lose their login status
  unless the Smart Card was then removed from the reader and re-inserted.

  All CAC users should upgrade to these updated packages, which resolve these
  issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0631.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the coolkey packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"coolkey-1.1.0-5.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"coolkey-devel-1.1.0-5.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"coolkey-1.1.0-5.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"coolkey-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-4129", value:TRUE);
}
if ( rpm_exists(rpm:"coolkey-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-4129", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0631", value:TRUE);
