#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25725);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-3304");

 name["english"] = "RHSA-2007-0662: httpd";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated Apache httpd packages that correct a security issue are now
  available for Red Hat Enterprise Linux 3 and 4.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  The Apache HTTP Server is a popular Web server.

  The Apache HTTP Server did not verify that a process was an Apache child
  process before sending it signals. A local attacker with the ability to run
  scripts on the Apache HTTP Server could manipulate the scoreboard and cause
  arbitrary processes to be terminated which could lead to a denial of
  service. (CVE-2007-3304).

  Users of httpd should upgrade to these updated packages, which contain
  backported patches to correct this issue. Users should restart Apache
  after installing this update.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0662.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the httpd packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"httpd-2.0.46-68.ent", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"httpd-devel-2.0.46-68.ent", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mod_ssl-2.0.46-68.ent", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"httpd-2.0.52-32.3.ent", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"httpd-devel-2.0.52-32.3.ent", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"httpd-manual-2.0.52-32.3.ent", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"httpd-suexec-2.0.52-32.3.ent", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mod_ssl-2.0.52-32.3.ent", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"httpd-2.0.46-68.ent", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"httpd-devel-2.0.46-68.ent", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mod_ssl-2.0.46-68.ent", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"httpd-2.0.52-32.3.ent", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"httpd-devel-2.0.52-32.3.ent", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"httpd-manual-2.0.52-32.3.ent", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"httpd-suexec-2.0.52-32.3.ent", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mod_ssl-2.0.52-32.3.ent", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"httpd-2.0.46-68.ent", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"httpd-devel-2.0.46-68.ent", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mod_ssl-2.0.46-68.ent", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"httpd-2.0.52-32.3.ent", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"httpd-devel-2.0.52-32.3.ent", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"httpd-manual-2.0.52-32.3.ent", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"httpd-suexec-2.0.52-32.3.ent", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"mod_ssl-2.0.52-32.3.ent", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"httpd-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-3304", value:TRUE);
}
if ( rpm_exists(rpm:"httpd-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-3304", value:TRUE);
}
if ( rpm_exists(rpm:"httpd-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-3304", value:TRUE);
}
if ( rpm_exists(rpm:"httpd-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-3304", value:TRUE);
}
if ( rpm_exists(rpm:"httpd-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-3304", value:TRUE);
}
if ( rpm_exists(rpm:"httpd-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-3304", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0662", value:TRUE);
