#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25726);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-3377", "CVE-2007-3409");

 name["english"] = "RHSA-2007-0674: perl";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated perl-Net-DNS packages that correct two security issues are now
  available for Red Hat Enterprise Linux 3 and 5.

  This update has been rated as having moderate security impact by the Red
  Hat Security Response Team.

  Net::DNS is a collection of Perl modules that act as a Domain Name System
  (DNS) resolver.

  A flaw was found in the way Net::DNS generated the ID field in a DNS query.
  This predictable ID field could be used by a remote attacker to return
  invalid DNS data. (CVE-2007-3377)

  A denial of service flaw was found in the way Net::DNS parsed certain DNS
  requests. A malformed response to a DNS request could cause the application
  using Net::DNS to crash or stop responding. (CVE-2007-3409)

  Users of Net::DNS should upgrade to these updated packages, which contain
  backported patches to correct these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0674.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the perl packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"perl-Net-DNS-0.59-3.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"perl-Net-DNS-0.31-4.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"perl-Net-DNS-0.59-3.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"perl-Net-DNS-0.31-4.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"perl-Net-DNS-0.31-4.el3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"perl-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-3377", value:TRUE);
 set_kb_item(name:"CVE-2007-3409", value:TRUE);
}
if ( rpm_exists(rpm:"perl-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-3377", value:TRUE);
 set_kb_item(name:"CVE-2007-3409", value:TRUE);
}
if ( rpm_exists(rpm:"perl-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-3377", value:TRUE);
 set_kb_item(name:"CVE-2007-3409", value:TRUE);
}
if ( rpm_exists(rpm:"perl-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-3377", value:TRUE);
 set_kb_item(name:"CVE-2007-3409", value:TRUE);
}
if ( rpm_exists(rpm:"perl-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-3377", value:TRUE);
 set_kb_item(name:"CVE-2007-3409", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0674", value:TRUE);
