#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(28236);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-2797");

 name["english"] = "RHSA-2007-0701: xterm";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  An updated xterm package that corrects a security issue is now available
  for Red Hat Enterprise Linux 4.

  This update has been rated as having low security impact by the Red
  Hat Security Response Team.

  The xterm program is a terminal emulator for the X Window System. It
  provides DEC VT102 and Tektronix 4014 compatible terminals for
  programs that cannot use the window system directly.

  A bug was found in the way xterm packages were built that caused the
  pseudo-terminal device files of the xterm emulated terminals to be owned by
  the incorrect group. This flaw did not affect Red Hat Enterprise Linux 4
  Update 4 and earlier. (CVE-2007-2797)

  All users of xterm are advised to upgrade to this updated package, which
  contains a patch to correct this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0701.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the xterm packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"xterm-192-8.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"xterm-192-8.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"xterm-192-8.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"xterm-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-2797", value:TRUE);
}
if ( rpm_exists(rpm:"xterm-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-2797", value:TRUE);
}
if ( rpm_exists(rpm:"xterm-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-2797", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0701", value:TRUE);
