#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25753);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CVE-2007-3089", "CVE-2007-3656", "CVE-2007-3734", "CVE-2007-3735", "CVE-2007-3736", "CVE-2007-3737", "CVE-2007-3738");

 name["english"] = "RHSA-2007-0724: firefox";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated firefox packages that fix several security bugs are now available
  for Red Hat Enterprise Linux 4 and 5.

  This update has been rated as having critical security impact by the Red
  Hat Security Response Team.

  Mozilla Firefox is an open source Web browser.

  Several flaws were found in the way Firefox processed certain malformed
  JavaScript code. A web page containing malicious JavaScript code could
  cause Firefox to crash or potentially execute arbitrary code as the user
  running Firefox. (CVE-2007-3734, CVE-2007-3735, CVE-2007-3737, CVE-2007-3738)

  Several content injection flaws were found in the way Firefox handled
  certain JavaScript code. A web page containing malicious JavaScript code
  could inject arbitrary content into other web pages. (CVE-2007-3736,
  CVE-2007-3089)

  A flaw was found in the way Firefox cached web pages on the local disk. A
  malicious web page may be able to inject arbitrary HTML into a browsing
  session if the user reloads a targeted site. (CVE-2007-3656)

  Users of Firefox are advised to upgrade to these erratum packages, which
  contain backported patches that correct these issues.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0724.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the firefox packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"firefox-1.5.0.12-3.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"firefox-devel-1.5.0.12-3.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"firefox-1.5.0.12-0.3.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"firefox-1.5.0.12-3.el5", release:"RHEL5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"firefox-1.5.0.12-0.3.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"firefox-1.5.0.12-0.3.el4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"firefox-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-3089", value:TRUE);
 set_kb_item(name:"CVE-2007-3656", value:TRUE);
 set_kb_item(name:"CVE-2007-3734", value:TRUE);
 set_kb_item(name:"CVE-2007-3735", value:TRUE);
 set_kb_item(name:"CVE-2007-3736", value:TRUE);
 set_kb_item(name:"CVE-2007-3737", value:TRUE);
 set_kb_item(name:"CVE-2007-3738", value:TRUE);
}
if ( rpm_exists(rpm:"firefox-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-3089", value:TRUE);
 set_kb_item(name:"CVE-2007-3656", value:TRUE);
 set_kb_item(name:"CVE-2007-3734", value:TRUE);
 set_kb_item(name:"CVE-2007-3735", value:TRUE);
 set_kb_item(name:"CVE-2007-3736", value:TRUE);
 set_kb_item(name:"CVE-2007-3737", value:TRUE);
 set_kb_item(name:"CVE-2007-3738", value:TRUE);
}
if ( rpm_exists(rpm:"firefox-", release:"RHEL5") )
{
 set_kb_item(name:"CVE-2007-3089", value:TRUE);
 set_kb_item(name:"CVE-2007-3656", value:TRUE);
 set_kb_item(name:"CVE-2007-3734", value:TRUE);
 set_kb_item(name:"CVE-2007-3735", value:TRUE);
 set_kb_item(name:"CVE-2007-3736", value:TRUE);
 set_kb_item(name:"CVE-2007-3737", value:TRUE);
 set_kb_item(name:"CVE-2007-3738", value:TRUE);
}
if ( rpm_exists(rpm:"firefox-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-3089", value:TRUE);
 set_kb_item(name:"CVE-2007-3656", value:TRUE);
 set_kb_item(name:"CVE-2007-3734", value:TRUE);
 set_kb_item(name:"CVE-2007-3735", value:TRUE);
 set_kb_item(name:"CVE-2007-3736", value:TRUE);
 set_kb_item(name:"CVE-2007-3737", value:TRUE);
 set_kb_item(name:"CVE-2007-3738", value:TRUE);
}
if ( rpm_exists(rpm:"firefox-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-3089", value:TRUE);
 set_kb_item(name:"CVE-2007-3656", value:TRUE);
 set_kb_item(name:"CVE-2007-3734", value:TRUE);
 set_kb_item(name:"CVE-2007-3735", value:TRUE);
 set_kb_item(name:"CVE-2007-3736", value:TRUE);
 set_kb_item(name:"CVE-2007-3737", value:TRUE);
 set_kb_item(name:"CVE-2007-3738", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0724", value:TRUE);
