#
# (C) Tenable Network Security
#
#
# The text of this plugin is (C) Red Hat Inc.

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25819);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-3387");

 name["english"] = "RHSA-2007-0735: xpdf";
 
 script_name(english:name["english"]);
 
 desc["english"] = '

  Updated xpdf packages that fix a security issue in PDF handling are
  now available for Red Hat Enterprise Linux 2.1, 3, and 4.

  This update has been rated as having important security impact by the Red
  Hat Security Response Team.

  Xpdf is an X Window System-based viewer for Portable Document Format (PDF)
  files.

  Maurycy Prodeus discovered an integer overflow flaw in the processing
  of PDF files. An attacker could create a malicious PDF file that would
  cause Xpdf to crash or potentially execute arbitrary code when opened.
  (CVE-2007-3387)

  All users of Xpdf should upgrade to these updated packages, which
  contain a backported patch to resolve this issue.




Solution : http://rhn.redhat.com/errata/RHSA-2007-0735.html
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the xpdf packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");
if ( rpm_check( reference:"xpdf-0.92-18.RHEL2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"xpdf-2.02-10.RHEL3", release:"RHEL3") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"xpdf-3.00-12.RHEL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"xpdf-0.92-18.RHEL2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"xpdf-3.00-12.RHEL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"xpdf-0.92-18.RHEL2", release:"RHEL2.1") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"xpdf-3.00-12.RHEL4", release:"RHEL4") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}

if ( rpm_exists(rpm:"xpdf-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-3387", value:TRUE);
}
if ( rpm_exists(rpm:"xpdf-", release:"RHEL3") )
{
 set_kb_item(name:"CVE-2007-3387", value:TRUE);
}
if ( rpm_exists(rpm:"xpdf-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-3387", value:TRUE);
}
if ( rpm_exists(rpm:"xpdf-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-3387", value:TRUE);
}
if ( rpm_exists(rpm:"xpdf-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-3387", value:TRUE);
}
if ( rpm_exists(rpm:"xpdf-", release:"RHEL2.1") )
{
 set_kb_item(name:"CVE-2007-3387", value:TRUE);
}
if ( rpm_exists(rpm:"xpdf-", release:"RHEL4") )
{
 set_kb_item(name:"CVE-2007-3387", value:TRUE);
}

set_kb_item(name:"RHSA-2007-0735", value:TRUE);
